#include ".\pythoninclude\Python.h"
#include "scripts.h"
#include "engine.h"
#include "helper_functions.h"

PyObject* scriptsdll_getposition(PyObject *self, PyObject *args)
{
	int id;
	Vector3 pos;
	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.getposition.\n Bad argument(s)?\n");
		return NULL;
	}
	pos = Commands->Get_Position(Commands->Find_Object(id));
	return Py_BuildValue("fff", pos.X, pos.Y, pos.Z);
}

PyCFunction* scriptsdll_setposition(PyObject *self, PyObject *args)
{
	float x,y,z;
	int id;
	Vector3 pos;

	if (!PyArg_ParseTuple(args, "ifff", &id, &x, &y, &z))
	{
		printf("\nError occured inside scriptsdll.setposition.\n Bad argument(s)?\n");
		printf("x = %f, y = %f, z = %f, id = %i", x, y, z, id);
		return NULL;
	}
	pos.X = x;
	pos.Y = y;
	pos.Z = z;
	printf("x = %f, y = %f, z = %f, id = %i", pos.X, pos.Y, pos.Z, id);
	Commands->Set_Position(Commands->Find_Object(id),pos);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

